<?php
include 'header-link.php';

// Ensure database connection exists
if (!isset($con)) {
    die("Database connection not established.");
}

// Fetch notifications from the database
$sql = "SELECT * FROM notify_user ORDER BY id DESC";
$result = $con->query($sql);

// Check if form is submitted to delete a notification
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['delete_id'])) {
    $delete_id = (int)$_POST['delete_id'];  // Ensure the ID is an integer
    if ($delete_id > 0) {
        $delete_sql = "DELETE FROM notify_user WHERE id = ?";
        $stmt = $con->prepare($delete_sql);
        $stmt->bind_param("i", $delete_id);
        $stmt->execute();
        $stmt->close();

        // Redirect to avoid re-submission
        header("Location: notify.php");
        exit();
    } else {
        echo "<p>Invalid notification ID.</p>";
    }
}
?>

<main>
    <section>
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon fa-duotone fa-solid fa-clapperboard"></i>
                            </div>

                            <h6 class="card-title text-center my-3">All User Notifications</h6>

                            <a class="btn btn-info m-3 d-block text-center" href="notify-add.php">Add New</a>

                            <!-- List of Notifications -->
                            <div class="offer-list" id="offerList">
                                <?php if ($result->num_rows > 0): ?>
                                    <?php while ($rate = $result->fetch_assoc()): ?>
                                        <div class="offer-card mb-3 p-4">
                                            <div class="row">
                                                <div class="col-md-12 text-left">
                                                    <small><span class="fw-bold">Title:</span> <strong><?php echo htmlspecialchars($rate['title']); ?></strong></small><br>
                                                    <small><span class="fw-bold">Date:</span> <?php echo htmlspecialchars($rate['date']); ?></small><br>
                                                    <small><span class="fw-bold">Message:</span> <strong><?php echo htmlspecialchars($rate['message']); ?></strong></small><br>
                                                    
                                                    <!-- Delete Form -->
                                                <div class="d-grid text-center">    
                                                    <form action="" method="POST" style="display:inline;">
                                                        <input type="hidden" name="delete_id" value="<?php echo $rate['id']; ?>">
                                                        <button type="submit" class="btn custom-button w-50 mx-auto" onclick="return confirm('Are you sure you want to delete this entry?')">
                                                            <i class="font fa-solid fa-trash"></i> Delete
                                                        </button>
                                                    </form>
                                                </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                <?php else: ?>
                                    <p>No notifications available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

</body>
</html>
